
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});
	$('#js-membership-type-form').validate({
		rules: {
			name: {
				required: true
			},
			amount: {
				required: true,
				number: true,
			},
			duration: {
				required: true
			},
		},
		messages: {
			name: "Please enter membership name",
			amount: {
				required: "Please enter amount",
				number: "Please enter a valid amount"
			},
			duration: "Please enter membership duration",
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
